<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Role extends Model 
{

    protected $table = 'roles';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description');
    protected $visible = array('name', 'description');

    public function abilities()
    {
        return $this->hasManyThrough('App\Models\Ability');
    }

}